#import <Foundation/Foundation.h>

@interface MyClass : NSObject
@property (atomic) NSString *atomicString; // default multi threaded, Locked
@property (nonatomic) NSString *nonatomicString; // single threaded, unlocked
@end
@implementation MyClass
@end

int main(int argc, const char * argv[])
{
    @autoreleasepool
    {
        MyClass *myObj = [MyClass new];
        myObj.atomicString = myObj.nonatomicString = @"Default";
        
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_BACKGROUND, 0), ^{
            myObj.atomicString = myObj.nonatomicString = @"Second Value";
        });
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_HIGH, 0), ^{
            myObj.atomicString = myObj.nonatomicString = @"Third Value";
        });
        
        NSLog(@"Atomic is: %@", myObj.atomicString);
        NSLog(@"Non Atomic is: %@", myObj.nonatomicString);
    }
    return 0;
}
